/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.collection.StackList;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class StackHelper {
    private StackHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static ItemStack fromBlockOrItem(IForgeRegistryEntry<?> blockOrItem) {
        if (blockOrItem instanceof Block) {
            return new ItemStack((Block)blockOrItem);
        }
        if (blockOrItem instanceof Item) {
            return new ItemStack((Item)blockOrItem);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack loadFromNBT(@Nullable NBTTagCompound tags) {
        return tags != null ? new ItemStack(tags) : ItemStack.field_190927_a;
    }

    @Deprecated
    @Nullable
    public static NBTTagCompound getTagCompound(ItemStack stack, boolean createIfNull) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (!stack.func_77942_o() && createIfNull) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static NBTTagCompound getOrCreateTagCompound(ItemStack stack) {
        if (stack.func_190926_b()) {
            return new NBTTagCompound();
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static List<ItemStack> getOres(String oreDictKey) {
        return OreDictionary.getOres((String)oreDictKey);
    }

    public static List<ItemStack> getOres(String oreDictKey, boolean alwaysCreateEntry) {
        return OreDictionary.getOres((String)oreDictKey, (boolean)alwaysCreateEntry);
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_190926_b()) {
            return list;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            list.add(OreDictionary.getOreName((int)id));
        }
        return list;
    }

    public static boolean matchesOreDict(ItemStack stack, String oreDictKey) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)id).equals(oreDictKey)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static StackList getNonEmptyStacks(IInventory inv) {
        StackList list = StackList.of(new ItemStack[0]);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            list.add(inv.func_70301_a(i));
        }
        return list;
    }

    public static ItemStack firstMatch(IInventory inv, Predicate<ItemStack> predicate) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !predicate.test(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

